//
//  DoubleComponentPickerViewController.m
//  Pickers
//
//  Created by Robert Górczyński on 11-06-22.
//

#import "DoubleComponentPickerViewController.h"


@implementation DoubleComponentPickerViewController
@synthesize doublePicker; 
@synthesize fillingTypes; 
@synthesize breadTypes; 

-(IBAction)buttonPressed 
{ 
    NSInteger fillingRow = [doublePicker selectedRowInComponent: 
							kFillingComponent]; 
    NSInteger breadRow = [doublePicker selectedRowInComponent: 
                          kBreadComponent]; 
	
    NSString *bread = [breadTypes objectAtIndex:breadRow]; 
    NSString *filling = [fillingTypes objectAtIndex:fillingRow];
    NSString *message = [[NSString alloc] initWithFormat: 
						 @"Twoja kanapka %@ z %@ będzie wkrótce gotowa.", bread, filling]; 
	
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle: 
						  @"Dziękujemy za zamówienie" 
                                                    message:message 
                                                   delegate:nil 
                                          cancelButtonTitle:@"Doskonale!" 
                                          otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
    [message release]; 
} 

- (void)viewDidLoad { 
    NSArray *fillingArray = [[NSArray alloc] initWithObjects:@"szynką", 
							 @"indykiem", @"masłem orzechowym", @"sałatką z tuńczyka", 
							 @"nutellą", @"pieczenią wołową", @"dżemem", nil]; 
    self.fillingTypes = fillingArray; 
    [fillingArray release]; 
	
    NSArray *breadArray = [[NSArray alloc] initWithObjects:@"chleb pszenny", 
						   @"chleb razowy", @"chleb żytni", @"bułka", @"rogal",nil]; 
    self.breadTypes = breadArray; 
    [breadArray release]; 
} 

- (void)didReceiveMemoryWarning {
    // Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
    
    // Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.doublePicker = nil; 
    self.breadTypes = nil; 
    self.fillingTypes = nil; 	
}


- (void)dealloc {
	[doublePicker release]; 
    [breadTypes release]; 
    [fillingTypes release]; 	
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody źródła danych dla kontrolki Picker
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView { 
    return 2;
} 

- (NSInteger)pickerView:(UIPickerView *)pickerView 
numberOfRowsInComponent:(NSInteger)component { 
    if (component == kBreadComponent) 
        return [self.breadTypes count]; 
	
    return [self.fillingTypes count]; 
} 

#pragma mark Metody delegata kontrolki Picker
- (NSString *)pickerView:(UIPickerView *)pickerView 
			 titleForRow:(NSInteger)row 
			forComponent:(NSInteger)component { 
    if (component == kBreadComponent) 
        return [self.breadTypes objectAtIndex:row]; 
    return [self.fillingTypes objectAtIndex:row]; 
} 

@end
